set more off
pause off
clear
set level 90
macro drop _all
graph set window fontface "Times New Roman"
set seed 1073741823

cd ""
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

use "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",clear

gen rlcapx_gva = ln(((capxq *1000000) / (gva_pindex/100)) + 1) * 100

cap drop sic3
gen sic3 = int(sic/1000)

**********************************************
******* appendix table b.2. sectoral heterogeneity
**********************************************

*keep if sic3 ==2 | sic3 ==3 // manufacturing
*keep if sic3 ==7 | sic3 ==8 // services
*drop if sic3 ==2 | sic3 ==3  | sic3 ==7 | sic3 ==8 // other sectors

**********************************************

rename GK_New2019 Extracted_MPShockE // mp shocks

replace Extracted_MPShockE = 0 if Extracted_MPShockE ==.

label var Extracted_MPShockE "MP Shock"
 
sort gvkeyn cyear cquarter
xtset gvkeyn qdate

capture macro drop nq
global nq = 1

capture drop shock_var*
capture drop group_var*

cap drop posit* negat*
gen positives = Extracted_MPShockE if gs1dp > 0 & gs1dp !=. 
gen negatives = Extracted_MPShockE if gs1dn < 0 & gs1dp !=.

replace positives = 0 if positives ==.
replace negatives = 0 if negatives ==.


by gvkeyn: gen int_share = xintq*100 / TotalDebt[_n-1]
gen logDebtIssuance = log(DebtIssuance)*100
gen logTotDebt = log(TotalDebt)*100
gen logRealAsset = log(atq/(gva_pindex/100))*100
gen logTotEmp = log(TotEmp)*100
rename TotalDebtGrowth DebtGrowth

by gvkeyn: gen dppentq_r = drealppentq*100/L.realppentq

sum dppentq_r, det
bys qdate: egen Threshold99 = pctile(dppentq_r) if dppentq_r ! = ., p(99)
replace dppentq_r  = . if dppentq_r > Threshold99

* ================================================================

**** RESPONSE VARIABLE, POLICY VARIABLE AND INSTRUMENT INTERACTIONS.

* ================================================================

sort gvkeyn qdate

*global dependent lnRealSales lnempC  invratio

*foreach y in $dependent {

capture macro drop response
global response  lnempC // invratio //lnRealSales 

*** change the response variable to "lnempC" for Figure 1.
*** change the response variable to "invratio" for Figure 2.
*** change the response variable to "lnRealSales" for Figure 3.

*** change response to "logrealcapx" for Appendix Figure C11 Panel A.
*** change response to  "dppentq_r"  for Appendix Figure C11 Panel B.

cap drop dlogrealcapx
sort gvkeyn qdate 
by gvkeyn: gen d$response = $response - L.$response

capture macro drop policy_variable
global policy_variable gs1d 

capture macro drop ppolicy_variable
global ppolicy_variable gs1dp  

capture macro drop pnolicy_variable
global npolicy_variable gs1dn 

capture macro drop instrument
global instrument Extracted_MPShockE 

capture macro drop ninstrument
global ninstrument negatives 

capture macro drop pinstrument
global pinstrument positives 
 
capture macro drop groupvar
capture macro drop shock_interact
capture macro drop mrate_interact
capture macro drop itc_interact
capture macro drop helpvar

capture macro drop var
global var "TI"

drop if DebtAssetRatio < 0
drop if LiquidityRatio < 0
drop if saleq < 0
drop if invratio < 0

drop if cyear < 1980
drop if cyear == 1980 & cquarter ==1
drop if cyear == 1980 & cquarter ==2

drop if cyear >= 2020


*drop if inrange(cyear,2008,2013) // exclude ZLB for Appendix Figure B.6.


*drop if cyear >= 1999 //  half the sample (Appendix Table B.6)
*drop if cyear < 1999 // half the sample (Appendix Table B.6)


label var lnRealSales "Percent"
label var lnempC "Percent"
label var invratio "Percentage Points"

*do "${mainpath}/Do/52A.LP_MP_Asym.do" // Produces Baseline Figures 1-3. 

do "${mainpath}/Do/52A.LP_MP_Asym_Table.do" // Produces Appendix Table C12.

*do "${mainpath}/Do/ROBUSTNESS/52A.LP_MP_No sign split.do" // Produces Pooled MP estimates, Appendix Figure B.7.

*do "${mainpath}/Do/ROBUSTNESS/52A.LP_BUSINESS_CYCLE.do" 

*do "${mainpath}/Do/ROBUSTNESS/Produce_FigB5.do" // Produces Appendix Figure B5

*capture macro drop $response

*}

cap log close
